<?php
/**
 * @author Michele Andreoli <michi.andreoli@gmail.com>
 * @name Paging.class.php
 * @version 0.4 updated: 16-03-2010
 * @license http://opensource.org/licenses/gpl-license-php GNU Public License
 * @package QueryPaging
 */

class Paging {
   private $current;
   private $numRows;
   private $currentUrl;
   private $get;

   /**
    * Constructor for Paging class
    * @param <int> $page number sent with $_GET[page], default is 1
    * @param <int> $numRows max rows number for every page
    * @param <String> $url the current page
    */
   public function  __construct($page, $numRows, $url) {
      if ($page > 0)
         $this->current = $page;
      else
         $this->current = 1;
      
      $this->numRows = $numRows;
      $this->currentUrl = $url;
      $this->get = "page";
   }

   /**
    * Set the name for GET value, default value is "page"
    * @param <String> $string name for $_GET['<custom name>']
    */
   public function setGETname($string) {
       $this->get = $string;
   }

   /**
    * Split the query result in pages
    * @param <Array> $result array with all the query result
    * @return <Array> array with the rows to show in page
    */
   public function rowsPerPage($result) {
      $res = array();
      $min = ($this->current-1) * ($this->numRows);
      $max = $min + $this->numRows;

      if($max > count($result))
          $max = count($result);

      for ($i = $min; $i < $max; $i++) {
          if ($result[$i] != null) {
            $res[] = $result[$i];
          }
      }

      return $res;
   }

   /**
    * Total of pages
    * @param <int> $n max number of elements in the query result array
    * @return <int> total number of pages
    */
   public function numPages($n) {
      $numPages = ceil($n / $this->numRows);

      return $numPages;
   }

   /**
    * Show the pages' links for the navigation with CSS style
    * @param <int> $n max number of elements in the query result array
    * @param <Array> $class names of the classes for CSS style. 0: link not selected, 1: link selected, 2: next and prev
    * @return <String> string with the links to show
    */
   public function printLinks($n, $class) {
      $links = "";

      if ($this->numPages($n) > 1 && $this->current > 1)
         $links = "<a title=\"press access key P for previous page\" accesskey=\"P\" class=\"$class[2]\" href=\"$this->currentUrl?$this->get=".$this->prevPage()."\">&lt;</a> ";

      for ($i = 1; $i <= $this->numPages($n); $i++) {
         if ($this->current == $i)
            $links .= "<a class=\"$class[1]\">$i</a> ";
         else
            $links .= "<a class=\"$class[0]\" href=\"$this->currentUrl?$this->get=".$i."\">$i</a> ";
      }

      if ($this->numPages($n) > 1 && $this->current < $this->numPages($n))
         $links .= "<a title=\"press access key N for next page\" accesskey=\"N\" class=\"$class[2]\" href=\"$this->currentUrl?$this->get=".$this->nextPage()."\">&gt;</a> ";

      echo "<b>Page(s)</b>  ". $links;
   }

   private function nextPage() {
      return $this->current+1;
   }

   private function prevPage() {
      return $this->current-1;
   }
}
?>
